var	XVLPlayer = null;

// mainMode = 0 -> use than direct part selection is wanted
// mainMode = 1 -> use than group selection is wanted
// group selection is without "%20%25" in the posno attribute (hotspot tag -> itemlist)
// see also mode argument at prepareID(.., mode)
var mainMode = 1; 
var startCutPathAt = 0;

function selectPart(pid) { // item selected in the partlist... now select it in the xvl player
	if(XVLPlayer != null) {
		pid=unescape(pid);
		XVLPlayer.model.enableRedraw = true;
		XVLPlayer.model.clearSelection();
		XVLPlayer.model.sameSelectColor = (mainMode == 1) ? true : false; 
		var	id;
		var grps = XVLPlayer.model.getAllGroups();
		var startCut;
		var allIds = new Array();
		for (var itemIndex0=0; itemIndex0<grps.length; itemIndex0++) {
			id = grps.item(itemIndex0).id;
			if (!id)
				continue;
			id = prepareID(id,mainMode);
			if (id == pid) {
				XVLPlayer.model.selectGroup(true, grps.item(itemIndex0), true);
				var group = grps.item(itemIndex0);
				allIds[allIds.length] = "\n";
				try {
				while(group.getParents() != null && group.getParents().length >0) {
					var h = group.getParents();
					allIds[allIds.length] = group.id;
					group = h.item(0);
				}
				allIds[allIds.length] = XVLPlayer.model.getRootGroups().item(0).id;
				allIds.reverse();
				} catch(e) {alert("Error in xvl_custom.js.selectPart(pid)");}				
				break;
			}
		}
	}
	if(allIds.length > 1) CurrentSelectionGPath = allIds.join("\n");
}

function XVLPlayerLoaded(XVLPlayerX) {
	XVLPlayer = XVLPlayerX;
	XVLPlayer.setAttribute("BGColor","#ffffff");
	XVLPlayer.model.selectColor = "#0000ff";
//	XVLPlayer.model.selectInstanceColor = "#0000ff";
}
var sh = false; // show | hide element
var CurrentSelectionGPath = null; 

function getRightGroup(gpathArr) {
	var index = 0;
	while(XVLPlayer.model.getGroup(gpathArr[index]) == null && index < gpathArr.length) {
		index++;
	}
	return XVLPlayer.model.getGroup(gpathArr[index]);
}

function getGrpPathCurrentSelection() {
	var n;
	var	d = 4;
	var	s = startCutPathAt;
	var 	orgPath = null;
	
	if(CurrentSelectionGPath == null) return null;
//	alert(">"+CurrentSelectionGPath+"<");
	orgPath = getPath(CurrentSelectionGPath,null);
	n = orgPath.length;
	if (d != 0 && d < orgPath.length) {
		n = d;
	}
	if (orgPath.length-s < n) {
		n = orgPath.length-s;
	}
	if (n < 1) {
		return;
	}
	return orgPath.slice(0, n);

}
var lastHiddenElementGrpPath = null;
function XVL_hideElem() {
	
	if(lastHiddenElementGrpPath != CurrentSelectionGPath) sh = false; // hide it
	
	var grpPath = getGrpPathCurrentSelection();
	var grpPathArr = prepareID(unescape(grpPath),mainMode);
	grpPathArr = grpPathArr.split(",");
	grpPathArr.reverse();
	var firstFoundId =0;
	for(g in grpPathArr) {
		if(grpPathArr[g] == "") firstFoundId++;
		else break;
	}
	
	var lastID = grpPathArr[firstFoundId];
	var id;
	var grps = XVLPlayer.model.getAllGroups();
	for (var itemIndex1=0; itemIndex1<grps.length; itemIndex1++) {
		id = grps.item(itemIndex1).id;
		if (!id) {
			continue;
		}
		
		id = prepareID(id,mainMode);
		if (id == lastID) {
			var matchedGrp = getRightGroup(grpPathArr);
			if(matchedGrp != null) { 
				XVLPlayer.model.showGroup(sh, matchedGrp, true);
				if(sh == true) selectPart(id);
			}
		}
	}
	lastHiddenElementGrpPath = CurrentSelectionGPath;
	sh = !sh;
}

function XVL_showAll() {
	XVLPlayer.model.showAll(true);
	sh=false;
}

function fitSelectedPart() {
XVLPlayer.execCommand(5,(XVLPlayer.execCommand(6) == 0)?1:0);
XVLPlayer.toFit();

}

function XVLPartSelected(obj,name) { // part selected in the xvl player... now select it in the xvl player and in the partlist
	if(XVLPlayer != null) {
	var	gpath;
		var n;
		var	d = 4;
		var	s = startCutPathAt;
		var 	orgPath = null;
		
		gpath = XVLPlayer.model.getPickedGPath();
		CurrentSelectionGPath = gpath;
		orgPath = getPath(gpath,null);
		n = orgPath.length;
		if (d != 0 && d < orgPath.length) {
			n = d;
		}
		if (orgPath.length-s < n) {
			n = orgPath.length-s;
		}
		if (n < 1) {
			return;
		}
		var grpPath = orgPath.slice(0, n);
	
		var x = prepareID(unescape(grpPath),mainMode);
		x = x.split(",");
		x.reverse();
		x = x[0];
		//belenusHome.eventHandler("HotspotsSelected","Sender=ImageView&HotspotID0="+escape(escape(escape(prepareID(x,mainMode))))+"&Exclusive=true");
		selectPart(x);
		belenusHome.eventHandler("HotspotsSelected","Sender=ImageView&HotspotID0="+escape(escape(escape(x)))+"&Exclusive=true");		
	}
}

function getPath(grpPath, mode)
{
	if (grpPath == null) {
		return null;
	}

	var	i;
	var	pathObj;
	var	tmpAry;
	mode = (mainMode == 1) ? true : false; 
	if (mode) {
		pathObj = grpPath.split("\n");
		if (1 < pathObj.length) {
			for (i=0; i<pathObj.length; i++) {
				pathObj[i] = escape(pathObj[i]);
			}
		} else {
			pathObj[0] = escape(pathObj[0]);
		}

	} else {
		tmpAry = grpPath.split("\n");
		for (j in tmpAry) {
			tmpAry[j] = unescape(tmpAry[j]);
		}
		pathObj = tmpAry;//.join("\n");
	}
	return pathObj;
}

function prepareID(id,mode) {
	// mode = 0; -> leave it like it is
	// mode = 1; -> cut of the "%20%25";
	if(mode == 0) return id;
	else {
		var decollator = "%20%25";
		id = escape(id);
		if(id.indexOf(decollator) != -1)
			return unescape(id.substring(0,id.lastIndexOf(decollator)));
		else return unescape(id);
	}
}

function setSemiTransparent(mode) {
	if (!XVLPlayer || XVLPlayer.execCommand(40)) return;
	
	var switchTo = (mode == true) ? 1 : 0;
	XVLPlayer.model.selectDisplayMode = switchTo;
}
function isSemiTransparent() {
	if (!XVLPlayer || XVLPlayer.execCommand(40)) return null;
	return (XVLPlayer.model.selectDisplayMode == 0) ? false : true;
}

function performAnim(direction) {
	if (!XVLPlayer || XVLPlayer.execCommand(40)) {
		return;
	}
	if (XVLPlayer.model.getAnimStatus()) {
		return;
	}
	if (!XVLPlayer.model.enableEventAct) {
		return;
	}

	switch (direction) {
		case "animOpen":
			direction = "UEExecAllFwd";
		break;
		case "animClose":
			direction = "UEExecAllRev";
		break;
	}

	if (!XVLPlayer.model.isDefinedEvent("XvlEventUser", direction)) {
		alert("No animation data is set.");
		return;
	}
	XVLPlayer.model.execUserEventAct(direction);
}

	function XVLMoveHandActivate() {
		if(XVLPlayer != null) {
			XVLPlayer.viewerOpeMode = 1;
			belenusHome.sendMessage("Toolbar","SetButtonStates","Name0=Rotate3d&State0=Enabled&Name1=MoveHand&State1=Pressed&Name2=FreeScale&State2=Enabled");
		}
	}
	function XVLRotate3dActivate() {
		if(XVLPlayer != null) {
			XVLPlayer.viewerOpeMode = 2;
			belenusHome.sendMessage("Toolbar","SetButtonStates","Name0=Rotate3d&State0=Pressed&Name1=MoveHand&State1=Enabled&Name2=FreeScale&State2=Enabled");
		}
	}
	function XVLFreeScaleActivate() {
		if(XVLPlayer != null) {
			XVLPlayer.viewerOpeMode = 4;
			belenusHome.sendMessage("Toolbar","SetButtonStates","Name0=Rotate3d&State0=Enabled&Name1=MoveHand&State1=Enabled&Name2=FreeScale&State2=Pressed");
		}
	}	
	function XVLFitToWidthPart() {
		if(XVLPlayer != null) {	
			XVLPlayer.execCommand(5,1);
			XVLPlayer.toFit();	
		}	
	}
	function XVLHideSelectedPart() {
		if(XVLPlayer != null)
			XVL_hideElem();
	}
	function XVLShowAllParts() {
		if(XVLPlayer != null)
			XVL_showAll();
	}
	function XVLSemiTransparent() {
		if(isSemiTransparent() != null)  {
			setSemiTransparent(!isSemiTransparent());
			if(isSemiTransparent()) belenusHome.sendMessage("Toolbar","SetButtonStates","Name0=SemiTransparent&State0=Pressed");
			else belenusHome.sendMessage("Toolbar","SetButtonStates","Name0=SemiTransparent&State0=Enabled");			
		}
	}
	function XVLFitToWindow() {
		if(XVLPlayer != null) {	
			XVLPlayer.execCommand(5,0);
			XVLPlayer.toFit();	
		}	
	} 